# Metavus Digital Collections Platform

Metavus is about collecting, describing, and disseminating resources online,
putting the power and control in your hands, to help you build and maintain
digital collections that meet your needs.

Key features of Metavus include:

- **Fully-configurable** and **extendable schemas** and **vocabularies** for records,
  collections, events, pages, news, and users, giving you unlimited flexibility
  for describing and managing content.

- Processing and data manipulation **rules** based on **conditions** and **search
  parameter sets**, giving you unlimited flexibility for **modifying** and **tracking
  content**.

- **Privileges** based on content and user **metadata**, giving you unlimited options
  for **granting** and **controlling access** to **content**.

- **Plugin-based architecture**, giving you unlimited opportunities to **expand** and
  **enhance** ways to **ingest**, **manipulate**, and **disseminate content**.

## Requirements

Metavus is designed to run on a web server with a [LAMP](
https://en.wikipedia.org/wiki/LAMP_(software_bundle)) (Linux/Apache/MySQL/PHP) stack.

The minimum required PHP version is 7.4.  The minimum required MySQL version is
5.0.  (MariaDB may also be used, in place of MySQL.)  (PHP 7.4 was released in
2019, so most servers put online in the last five years or that are older but
actively-maintained should work fine.)

## Installation

Installation of Metavus usually takes less than five minutes.  Steps:

1. [Download](https://metavus.net/download/) the Metavus distribution package.

2. Create a new database for Metavus on your web server, and a MySQL (or
   MariaDB) user who has all privileges for accessing and modifying that database.

3. Unzip the Metavus package and upload the files to the desired location on
   your web server.

4. Access your new Metavus installation using a web browser (go to, for
   example, "http://example.com" or "http://example.com/collection/", depending
   on your domain and which directory you uploaded the files to), and follow
   the instructions on that page to complete the installation.

## Licensing

Metavus is licensed under version 2 of the GNU General Public License.  Please
see the included LICENSE.txt file for details.

## Further Information

A live demonstration version of Metavus is available online: [Metavus 
Demo Site](https://demo.metavus.net)

Metavus is maintained by the [Internet Scout Research Group](
https://scout.wisc.edu) at the University of Wisconsin-Madison.

For more information, please see [https://metavus.net](https://metavus.net/)
