<?PHP
#
#   FILE:  MetadataFieldOrdering.php
#
#   Part of the Metavus digital collections platform
#   Copyright 2012-2025 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#
# @scout:phpstan

use Metavus\MetadataFieldGroup;
use Metavus\MetadataFieldOrder;
use Metavus\MetadataSchema;
use Metavus\User;
use ScoutLib\ApplicationFramework;
use ScoutLib\StdLib;

# ----- MAIN -----------------------------------------------------------------
$AF = ApplicationFramework::getInstance();
$AF->setPageTitle("Metadata Field Ordering");
if (!User::requirePrivilege(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {
    return;
}

# get the schema ID or use the default one if not specified
$SchemaId = StdLib::getArrayValue(
    $_GET,
    "SC",
    StdLib::getFormValue("F_SchemaId", MetadataSchema::SCHEMAID_DEFAULT)
);

# construct the metadata schema
$H_Schema = new MetadataSchema($SchemaId);

$H_GroupIdOffset = $H_Schema->getHighestFieldId() + 100;

# construct the order objects
$H_DisplayOrder = $H_Schema->getDisplayOrder();
$H_EditOrder = $H_Schema->getEditOrder();

# in case a bug results in any issues, try to fix them
$H_DisplayOrder->mendIssues();
$H_EditOrder->mendIssues();

$H_ButtonPushed = StdLib::getFormValue("Submit");

if ($H_ButtonPushed == "Add") {
    # get values from the user
    $GroupName = StdLib::getFormValue("F_GroupName");
    $Ordering = StdLib::getFormValue("F_Ordering");

    if ($GroupName && ($Ordering == "Display" || $Ordering == "Edit")) {
        $Order = $Ordering == "Display" ? $H_DisplayOrder : $H_EditOrder;
        $Order->createGroup($GroupName);
    }
    # change pushed button to "Save" so we save changes
    $H_ButtonPushed = "Save";
} elseif (preg_match("[^DeleteGroup]", (string)$H_ButtonPushed)) {
    # get values from the user, index 0 contains "DeleteGroup"
    # used in the preg_match above to activate this code
    $Ids = explode(",", $H_ButtonPushed);
    $GroupId = $Ids[1];
    $OrderId = $Ids[2];

    if ($OrderId && $GroupId) {
        $Order = new MetadataFieldOrder((int) $OrderId);
        $Group = new MetadataFieldGroup((int) $GroupId);

        $Order->deleteGroup($Group);
    }
} elseif ($H_ButtonPushed == "EditGroupName") {
    # get values from the user
    $GroupId = StdLib::getFormValue("F_GroupId");
    $GroupName = StdLib::getFormValue("F_GroupName");

    if ($GroupId && $GroupName) {
        $Group = new MetadataFieldGroup($GroupId);
        $Group->name($GroupName);
    }
}
# outside of elseif chain so you can save after adding without abstraction
if ($H_ButtonPushed == "Save Changes") {
    # get orders from hidden input, generated by nestedSortable::serialize()
    parse_str(StdLib::getFormValue("editOrder"), $EditOrder);
    parse_str(StdLib::getFormValue("displayOrder"), $DisplayOrder);

    # save new order
    if (is_array($EditOrder['edit-item']) && is_array($DisplayOrder["display-item"])) {
        $H_EditOrder->reorder($EditOrder["edit-item"], $H_GroupIdOffset);
        $H_DisplayOrder->reorder($DisplayOrder["display-item"], $H_GroupIdOffset);
    }

    # clear page cache so changed ordering will take effect
    $AF->clearPageCache();
}
