<?PHP
#
#   FILE:  PluginUpgrade_1_0_3.php (AutoFetch plugin)
#
#   A plugin upgrade file for the Metavus digital collections platform
#   Copyright 2024 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#
# @scout:phpstan

namespace Metavus\Plugins\AutoFetch;

use ScoutLib\Database;
use ScoutLib\PluginUpgrade;

/**
 * Class for upgrading the AutoFetch plugin to version 1.0.3.
 */
class PluginUpgrade_1_0_3 extends PluginUpgrade
{
    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
     * Perform actions necessary to upgrade plugin to version 1.0.3.
     * @return null|string Return NULL if upgrade succeeeded, or string
     *      containing error message if upgrade failed.
     */
    public function performUpgrade()
    {
        $DB = new Database();
        $DB->query(
            "ALTER TABLE AutoFetch_Urls "
            ."CHANGE COLUMN LastCheck LastCheck TIMESTAMP DEFAULT NOW()"
        );
        return null;
    }

    # ---- PRIVATE INTERFACE -------------------------------------------------
}
