<?PHP
#
#   FILE:  PluginUpgrade_1_0_20.php (Blog plugin)
#
#   A plugin upgrade file for the Metavus digital collections platform
#   Copyright 2024 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#
# @scout:phpstan

namespace Metavus\Plugins\Blog;

use Metavus\Plugins\Blog;
use ScoutLib\PluginUpgrade;

/**
 * Class for upgrading the Blog plugin to version 1.0.20.
 */
class PluginUpgrade_1_0_20 extends PluginUpgrade
{
    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
     * Perform actions necessary to upgrade plugin to version 1.0.20.
     * @return null|string Return NULL if upgrade succeeeded, or string
     *      containing error message if upgrade failed.
     */
    public function performUpgrade()
    {
        $Plugin = Blog::getInstance(true);
        $AllSettings = $Plugin->getConfigSetting("BlogSettings");

        foreach ($AllSettings as $Id => $BlogSettings) {
            if ((is_null($BlogSettings["CleanUrlPrefix"]) ||
                trim($BlogSettings["CleanUrlPrefix"]) == "") &&
                !is_null($BlogSettings["BlogName"])) {
                $AllSettings[$Id]["CleanUrlPrefix"] =
                $Plugin->generateCleanUrlPrefix($BlogSettings["BlogName"]);
            }
        }
        return null;
    }

    # ---- PRIVATE INTERFACE -------------------------------------------------
}
