<?PHP
#
#   FILE:  PluginUpgrade_1_2_0.php (Folders plugin)
#
#   A plugin upgrade file for the Metavus digital collections platform
#   Copyright 2024 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#
# @scout:phpstan

namespace Metavus\Plugins\Folders;

use Metavus\Plugins\Folders;
use ScoutLib\Database;
use ScoutLib\PluginUpgrade;

/**
 * Class for upgrading the Folders plugin to version 1.2.0.
 */
class PluginUpgrade_1_2_0 extends PluginUpgrade
{
    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
     * Perform actions necessary to upgrade plugin to version 1.2.0.
     * @return null|string Return NULL if upgrade succeeeded, or string
     *      containing error message if upgrade failed.
     */
    public function performUpgrade()
    {
        return $this->createMissingTables();
    }

    # ---- PRIVATE INTERFACE -------------------------------------------------
}
