<?PHP
#
#   FILE:  PluginUpgrade_1_3_5.php (GoogleMaps plugin)
#
#   A plugin upgrade file for the Metavus digital collections platform
#   Copyright 2024 Edward Almasy and Internet Scout Research Group
#   http://metavus.net
#
# @scout:phpstan

namespace Metavus\Plugins\GoogleMaps;

use ScoutLib\ApplicationFramework;
use ScoutLib\PluginUpgrade;

/**
 * Class for upgrading the GoogleMaps plugin to version 1.3.5.
 */
class PluginUpgrade_1_3_5 extends PluginUpgrade
{
    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
     * Perform actions necessary to upgrade plugin to version 1.3.5.
     * @return null|string Return NULL if upgrade succeeeded, or string
     *      containing error message if upgrade failed.
     */
    public function performUpgrade()
    {
        ApplicationFramework::getInstance()
            ->queueUniqueTask(
                '\Metavus\Plugins\GoogleMaps\CallbackManager'
                    .'::removeGetAndPostFromEnvironmentData'
            );
        return null;
    }

    # ---- PRIVATE INTERFACE -------------------------------------------------
}
